package gov.va.med.mhv.usermgmt.common.dto;

import java.sql.Timestamp;

import org.apache.commons.lang3.StringUtils;

import gov.va.med.mhv.usermgmt.common.enums.MhvDownloadReportStatus;

public class MhvDownloadReportDTO {
	private long		downloadReportId;
	private int 	 	oplock;
	private String		fileName;
	private Timestamp	modifiedTime;
	private long		userProfileId;
	private String		errorMessage;
	private MhvDownloadReportStatus		status;
	private long		fileSize;
	private Timestamp	lastAccess;
	private Timestamp	createdTime;

	public MhvDownloadReportDTO() {};
	
	public MhvDownloadReportDTO(long downloadReportId,
							 int oplock,
							 String fileName,
							 Timestamp modifiedTime,
							 long userProfileId,
							 String errorMessage,
							 MhvDownloadReportStatus status,
							 long fileSize,
							 Timestamp lastAccess,
							 Timestamp createdTime) {
		this.downloadReportId = downloadReportId;
		this.oplock = oplock;
		this.fileName = fileName;
		this.modifiedTime = modifiedTime;
		this.userProfileId = userProfileId;
		this.errorMessage = errorMessage;
		this.status = status;
		this.fileSize = fileSize;
		this.lastAccess = lastAccess;
		this.createdTime = createdTime;
	}

	public Long getDownloadReportId() {
		return downloadReportId;
	}
	
	public void setDownloadReportId(Long downloadReportId) {
		this.downloadReportId = downloadReportId;
	}
	
	public Integer getOplock() {
		return oplock;
	}
	
	private void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getFileName() {
		return fileName;
	}
	
	public void setFileName(String fileName) {
		fileName = StringUtils.trimToNull(fileName);
		this.fileName = fileName;
	}
	
	public Timestamp getModifiedTime() {
		return modifiedTime;
	}
	
	public void setModifiedTime(Timestamp modifiedTime) {
		this.modifiedTime = modifiedTime;
	}
	
	public Long getUserProfileId() {
		return userProfileId;
	}
	
	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}
	
	public String getErrorMessage() {
		return errorMessage;
	}
	
	public void setErrorMessage(String errorMessage) {
		errorMessage = StringUtils.trimToNull(errorMessage);
		this.errorMessage = errorMessage;
	}
	
	public MhvDownloadReportStatus getStatus() {
		return status;
	}
	
	public void setStatus(MhvDownloadReportStatus status) {
		this.status = status;
	}
	
	public Long getFileSize() {
		return fileSize;
	}
	
	public void setFileSize(Long fileSize) {
		this.fileSize = fileSize;
	}
	
	public Timestamp getLastAccess() {
		return lastAccess;
	}
	
	public void setLastAccess(Timestamp lastAccess) {
		this.lastAccess = lastAccess;
	}
	

	public Timestamp getCreatedTime() {
		return createdTime;
	}
	
	public void setCreatedTime(Timestamp createdTime) {
		this.createdTime = createdTime;
	}
}